from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class WorseAndWorse3(Player):
    """
    Cooperates in the first turn.
    Then defects with probability no. of opponent defects / (current turn - 1).
    Therefore it is more likely to defect when the opponent defects for a larger
    proportion of the turns.

    Names:
        - Worse and Worse 3: [Prison1998]_
    """

    name = "Worse and Worse 3"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        current_round = len(self.history) + 1

        if current_round == 1:
            return C
        else:
            probability = 1 - opponent.defections / (current_round - 1)
            return self._random.random_choice(probability)